% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelist.R
\name{list_sdmx_codelist}
\alias{list_sdmx_codelist}
\title{List SDMX codelist for a given agency and codelist identifier}
\usage{
list_sdmx_codelist(
  agency = "UNICEF",
  codelist_id,
  retry = 3L,
  cache_dir = tools::R_user_dir("get_sdmx", "cache")
)
}
\arguments{
\item{agency}{Character agency ID (e.g., "UNICEF").}

\item{codelist_id}{Character codelist identifier (e.g., "CL_UNICEF_INDICATOR").}

\item{retry}{Number of retries for HTTP failures; default is 3.}

\item{cache_dir}{Directory for on-disk cache; created if it does not exist.}
}
\value{
A tibble with columns \code{code}, \code{description}, and \code{name}.
}
\description{
Download and cache the SDMX codelist definitions from a specified agency's REST endpoint.
}
