% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_registry.R
\name{list_indicators}
\alias{list_indicators}
\title{List Indicators}
\usage{
list_indicators(dataflow = NULL, name_contains = NULL)
}
\arguments{
\item{dataflow}{Character. Filter by dataflow/category (e.g., "CME", "NUTRITION")}

\item{name_contains}{Character. Filter by name substring (case-insensitive)}
}
\value{
Named list of matching indicators
}
\description{
List all known indicators, optionally filtered by dataflow or name.
}
\examples{
\donttest{
# Get all mortality indicators
mortality <- list_indicators(dataflow = "CME")

# Search by name
stunting <- list_indicators(name_contains = "stunting")
}

}
