% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_registry.R
\name{indicator_registry}
\alias{indicator_registry}
\title{Indicator Registry - Auto-sync UNICEF Indicator Metadata}
\description{
Key features:
\itemize{
\item Automatic download of indicator codelist from UNICEF SDMX API
\item Maps each indicator code to its dataflow (category)
\item Caches metadata locally in config/unicef_indicators_metadata.yaml
\item Supports offline usage after initial sync
\item Version tracking for cache freshness
}
}
\details{
This module automatically fetches and caches the complete UNICEF indicator
codelist from the SDMX API. The cache is created on first use and can be
refreshed on demand.
}
\examples{
# Auto-detect dataflow from indicator code
dataflow <- get_dataflow_for_indicator("CME_MRY0T4")
print(dataflow)  # "CME"

# Refresh cache manually
refresh_indicator_cache()

}
