% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sdmx.R
\name{get_sdmx}
\alias{get_sdmx}
\title{Fetch SDMX data or structure from any agency}
\usage{
get_sdmx(
  agency = "UNICEF",
  flow,
  key = NULL,
  start_period = NULL,
  end_period = NULL,
  nofilter = FALSE,
  detail = c("data", "structure"),
  version = NULL,
  format = c("csv", "sdmx-xml", "sdmx-json"),
  labels = c("id", "both", "none"),
  tidy = TRUE,
  country_names = TRUE,
  page_size = 100000L,
  retry = 3L,
  cache = FALSE,
  sleep = 0.2,
  post_process = NULL
)
}
\arguments{
\item{agency}{Character agency ID (e.g., "UNICEF").}

\item{flow}{Character vector of flow IDs; length >= 1.}

\item{key}{Optional character vector of codes to filter the flow.}

\item{start_period}{Optional single 4-digit year for start (e.g., 2000).}

\item{end_period}{Optional single 4-digit year for end (e.g., 2020).}

\item{nofilter}{Logical; if TRUE, fetch all disaggregations (no pre-fetch filtering);
if FALSE (default), use efficient pre-fetch filtering (totals only per schema).}

\item{detail}{One of "data" or "structure"; default "data".}

\item{version}{Optional SDMX version; if NULL, auto-detected via list_sdmx_flows().}

\item{format}{One of "csv", "sdmx-xml", "sdmx-json"; default "csv".}

\item{labels}{One of "both","id","none"; default "both".}

\item{tidy}{Logical; if TRUE, rename core columns and retain metadata; default TRUE.}

\item{country_names}{Logical; if TRUE, join ISO3 to country names; default TRUE.}

\item{page_size}{Rows per page for CSV; default 100000L.}

\item{retry}{Number of retries; default 3L.}

\item{cache}{Logical; if TRUE, cache per flow on disk; default FALSE.}

\item{sleep}{Pause (in seconds) between pages; default 0.2.}

\item{post_process}{Optional function to apply to raw tibble before tidy-up.}
}
\value{
A tibble (or list of tibbles) for data, or xml_document(s) for structure.
}
\description{
Download one or more SDMX flows from a specified agency,
with paging, retries, caching, format & labels options, and post-processing.

Schemas are cached in memory per session for performance: subsequent indicators
from the same dataflow load 8-17x faster (2.2s --> 0.13s).
}
