% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_registry.R
\name{get_dataflow_for_indicator}
\alias{get_dataflow_for_indicator}
\title{Get Dataflow for Indicator}
\usage{
get_dataflow_for_indicator(indicator_code, default = "GLOBAL_DATAFLOW")
}
\arguments{
\item{indicator_code}{Character. UNICEF indicator code (e.g., "CME_MRY0T4")}

\item{default}{Character. Default dataflow if indicator not found (default: "GLOBAL_DATAFLOW")}
}
\value{
Character. Dataflow name (e.g., "CME", "NUTRITION", "EDUCATION")
}
\description{
Returns the dataflow (category) for a given indicator code. This function
automatically loads the indicator cache on first use, fetching from the
UNICEF SDMX API if necessary.
}
\details{
IMPORTANT: Known dataflow overrides are checked FIRST, before the cache.
This ensures problematic indicators (where the API metadata is wrong)
always get the correct dataflow.
}
\examples{
\donttest{
get_dataflow_for_indicator("CME_MRY0T4")
# Returns: "CME"

get_dataflow_for_indicator("NT_ANT_HAZ_NE2_MOD")
# Returns: "NUTRITION"

get_dataflow_for_indicator("ED_CR_L1_UIS_MOD")
# Returns: "EDUCATION_UIS_SDG" (uses override, not wrong cache value)
}

}
