% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicef_core.R
\name{filter_unicef_data}
\alias{filter_unicef_data}
\title{Filter UNICEF Data (Sex, Age, Wealth, etc.)}
\usage{
filter_unicef_data(
  df,
  sex = NULL,
  age = NULL,
  wealth = NULL,
  residence = NULL,
  maternal_edu = NULL,
  verbose = TRUE,
  indicator_code = NULL,
  dataflow = NULL
)
}
\arguments{
\item{df}{Data frame to filter.}

\item{sex}{Character string for sex filter (e.g. "F", "M", "_T").}

\item{age}{Character string for age filter.}

\item{wealth}{Character string for wealth quintile filter.}

\item{residence}{Character string for residence filter.}

\item{maternal_edu}{Character string for maternal education filter.}

\item{verbose}{Logical, print progress messages.}

\item{indicator_code}{Optional indicator code to enable metadata-driven filtering.
Placed at end to preserve backward compatibility with existing positional calls.}

\item{dataflow}{Optional dataflow name for dataflow-specific filtering logic.
For NUTRITION dataflow, age defaults to Y0T4 instead of _T.}
}
\value{
A filtered data frame matching the specified disaggregation criteria.
}
\description{
Filters data to specific disaggregations or defaults to totals.
Uses indicator metadata (disaggregations_with_totals) to determine which
dimensions have _T totals and should be filtered by default.
}
