% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{ensure_metadata}
\alias{ensure_metadata}
\title{Ensure metadata is synced and fresh}
\usage{
ensure_metadata(max_age_days = 30, verbose = FALSE, cache_dir = NULL)
}
\arguments{
\item{max_age_days}{Maximum age in days before re-sync (default: 30)}

\item{verbose}{Print messages}

\item{cache_dir}{Optional cache directory path}
}
\value{
Logical indicating if sync was performed
}
\description{
Checks if metadata exists and is within max_age_days.
If not, performs a sync automatically.
}
\examples{
\donttest{
# Check every 30 days (default)
ensure_metadata()

# Check every 7 days
ensure_metadata(max_age_days = 7)
}
}
