% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicef_core.R
\name{.fetch_one_flow}
\alias{.fetch_one_flow}
\title{Fetch data from a single dataflow with 404 detection}
\usage{
.fetch_one_flow(
  indicator,
  dataflow,
  countries = NULL,
  start_year_str = NULL,
  end_year_str = NULL,
  max_retries = 3,
  version = "1.0",
  page_size = 1e+05,
  verbose = TRUE,
  totals = FALSE,
  labels = "id"
)
}
\arguments{
\item{indicator}{Character vector of indicator codes}

\item{dataflow}{Character string of dataflow ID}

\item{countries}{Character vector of ISO3 country codes (optional)}

\item{start_year_str}{Character string of start year (optional)}

\item{end_year_str}{Character string of end year (optional)}

\item{max_retries}{Integer number of retry attempts}

\item{version}{SDMX version string (default "1.0")}

\item{page_size}{Integer number of rows per page}

\item{verbose}{Logical for progress messages}

\item{totals}{Logical for including totals}

\item{labels}{Label format ("id" or "name")}
}
\value{
List with status ("ok" or "not_found") and df (data.frame or NULL)
}
\description{
Low-level helper that fetches indicator data from a specific dataflow.
Returns status "not_found" for 404 errors (allowing fallback to other dataflows)
or throws for other errors.
}
\keyword{internal}
