% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flows.R
\name{dataflow_schema}
\alias{dataflow_schema}
\title{Get dataflow schema information}
\usage{
dataflow_schema(dataflow, metadata_dir = NULL)
}
\arguments{
\item{dataflow}{Character. The dataflow ID (e.g., "CME", "EDUCATION").}

\item{metadata_dir}{Optional path to metadata directory. Auto-detected if NULL.}
}
\value{
A list with components: id, name, version, agency, dimensions, attributes.
}
\description{
Display the dimensions and attributes for a UNICEF dataflow.
Reads from local YAML schema files in metadata/current/dataflows/.
}
\examples{
\donttest{
# Get schema for Child Mortality dataflow
schema <- dataflow_schema("CME")
print(schema$dimensions)
print(schema$attributes)
}
}
