% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{compare_vintages}
\alias{compare_vintages}
\title{Compare two metadata vintages}
\usage{
compare_vintages(vintage1, vintage2 = NULL, cache_dir = NULL)
}
\arguments{
\item{vintage1}{Earlier vintage date (YYYY-MM-DD)}

\item{vintage2}{Later vintage date (YYYY-MM-DD) or NULL for current}

\item{cache_dir}{Optional cache directory path}
}
\value{
List with added, removed, and changed items
}
\description{
Compares dataflows between two vintages to identify additions,
removals, and modifications.
}
\examples{
\dontrun{
# Compare historical vintage to current
changes <- compare_vintages("2025-11-15")

# Compare two historical vintages
changes <- compare_vintages("2025-10-01", "2025-11-15")

if (length(changes$added) > 0) {
  message(sprintf("New dataflows: \%s", paste(changes$added, collapse = ", ")))
}
}
}
