% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unicef_core.R
\name{clear_unicef_cache}
\alias{clear_unicef_cache}
\title{Clear All UNICEF Caches}
\usage{
clear_unicef_cache(reload = TRUE, verbose = TRUE)
}
\arguments{
\item{reload}{Logical. If TRUE (default), immediately reload YAML-based
caches (indicators metadata, fallback sequences, region codes).
If FALSE, caches are cleared but not reloaded until next use.}

\item{verbose}{Logical. If TRUE, print what was cleared.}
}
\value{
Invisibly returns a named list of cleared cache names.
}
\description{
Resets all in-memory caches across the package: indicator metadata,
fallback sequences, region codes, schema cache, and config cache.
After clearing, the next API call will reload all metadata from
YAML files (or fetch fresh from the API if file cache is stale).
}
\examples{
\donttest{
  # Clear everything and reload
  clear_unicef_cache()

  # Clear without reloading (lazy reload on next use)
  clear_unicef_cache(reload = FALSE)
}
}
