% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_pack_rows.R
\name{tt_pack_rows}
\alias{tt_pack_rows}
\title{Group rows under a label}
\usage{
tt_pack_rows(
  table,
  group_label = NULL,
  start_row = NULL,
  end_row = NULL,
  index = NULL,
  indent = TRUE,
  bold_label = TRUE
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{group_label}{The label text for the group (used with \code{start_row}/\code{end_row}).}

\item{start_row}{First row number in the group (1-indexed).}

\item{end_row}{Last row number in the group.}

\item{index}{A named numeric vector for multiple groups (alternative style).
Names are group labels, values are row counts.
Example: \code{c("Group A" = 3, "Group B" = 5)} creates two groups where
"Group A" covers rows 1-3 and "Group B" covers rows 4-8.}

\item{indent}{Logical. Indent rows in the group (default TRUE).}

\item{bold_label}{Logical. Make the group label bold (default TRUE).}
}
\value{
The modified \code{typst_table} object.
}
\description{
Inserts a group label row and optionally indents the grouped rows.
Useful for creating visual sections in the table.
}
\examples{
# Group rows with a label
tt(mtcars[1:10, 1:3], rownames = FALSE) |>
  tt_pack_rows("4 Cylinders", 1, 5) |>
  tt_pack_rows("6 Cylinders", 6, 10)

# Using index parameter (alternative style)
tt(mtcars[1:10, 1:3], rownames = FALSE) |>
  tt_pack_rows(index = c("4 Cylinders" = 5, "6 Cylinders" = 5))

}
