% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnose_model_trend.R
\encoding{UTF-8}
\name{diagnose_model_trend}
\alias{diagnose_model_trend}
\title{Diagnose a fitted model using residual plots and statistical tests (ggplot2 only) /
Modell-Diagnose mittels Residuenplots und statistischen Tests (nur ggplot2)}
\usage{
diagnose_model_trend(
  model,
  value_col = "value",
  residual_type = "deviance",
  group_col = NULL,
  verbose = TRUE
)
}
\arguments{
\item{model}{A fitted model object (lm, glm, gam, or zeroinfl). / Ein angepasstes Modellobjekt (lm, glm, gam oder zeroinfl).}

\item{value_col}{Name of the response variable (used in axis labels). / Name der Zielvariable (verwendet fuer Achsenbeschriftungen).}

\item{residual_type}{Type of residuals to use ("deviance", "pearson", "response", etc.). / Art der Residuen ("deviance", "pearson", "response" usw.).}

\item{group_col}{Optional. Grouping variable to color residual plots. / Optional. Gruppierungsvariable fuer Farbgebung in den Residuenplots.}

\item{verbose}{Logical; whether to print diagnostic messages. / Logisch; ob Diagnosenachrichten ausgegeben werden sollen.}
}
\value{
A list with ggplot2 plots and diagnostic test results. /
Eine Liste mit ggplot2-Plots und diagnostischen Testergebnissen:
\describe{
  \item{plots}{A named list with residual plots ("residuals_vs_fitted", "qq", "scale_location"). /
               Eine Liste mit Residuenplots ("residuals_vs_fitted", "qq", "scale_location").}
  \item{diagnostics}{A named list of statistical test results ("Shapiro", "KS", "Levene", "GAM check"). /
                     Eine Liste mit Ergebnissen statistischer Tests ("Shapiro", "KS", "Levene", "GAM check").}
}
}
\description{
Diagnose model fit for lm, glm, gam (mgcv), and zeroinfl (pscl) models using residual plots and tests. /
Diagnose lineare Modelle (lm), generalisierte lineare Modelle (glm), GAMs von mgcv und Zero-Inflated-Modelle von pscl mit ggplot2.
}
\examples{
# Example for a linear model
set.seed(123)
df <- data.frame(x = rnorm(100), y = rnorm(100))
model_lm <- lm(y ~ x, data = df)
diagnose_model_trend(model_lm)

# Beispiel fuer ein GLM
df_glm <- data.frame(x = rnorm(100), y = rpois(100, lambda = 2))
model_glm <- glm(y ~ x, data = df_glm, family = poisson())
diagnose_model_trend(model_glm)

}
\seealso{
[explore_poisson_trend], [explore_continuous_trend], [explore_zinb_trend], [explore_trend_auto]
}
