% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tramvs.R
\name{tramvs}
\alias{tramvs}
\title{Select optimal subset based on high dimensional BIC}
\usage{
tramvs(
  formula,
  data,
  modFUN,
  mandatory = NULL,
  supp_max = NULL,
  k_max = NULL,
  thresh = NULL,
  init = TRUE,
  m_max = 10,
  m0 = NULL,
  verbose = TRUE,
  parallel = FALSE,
  future_args = list(strategy = "multisession", workers = supp_max),
  ...
)
}
\arguments{
\item{formula}{object of class \code{"formula"}.}

\item{data}{data frame containing the variables in the model.}

\item{modFUN}{function for fitting a transformation model, e.g., \code{BoxCox()}.}

\item{mandatory}{formula of mandatory covariates, which will always be included
and estimated in the model. Note that this also changes the intialization
of the active set. The active set is then computed with regards to the
model residuals of \code{modFUN(mandatory, ...)} instead of the unconditional
model.}

\item{supp_max}{maximum support which to call \code{abess_tram} with.}

\item{k_max}{maximum support size to consider during the splicing algorithm.
Defaults to \code{supp}.}

\item{thresh}{threshold when to stop splicing. Defaults to
0.01 * \code{supp} * p * log(log(n)) / n$, where p denotes the number of predictors
and n the sample size.}

\item{init}{initialize active set. Defaults to \code{TRUE} and initializes the
active set with those covariates that are most correlated with score residuals
of an unconditional \code{modFUN(update(formula, . ~ 1))}.}

\item{m_max}{maximum number of iterating the splicing algorithm.}

\item{m0}{Transformation model for initialization}

\item{verbose}{show progress bar (default: \code{TRUE})}

\item{parallel}{toggle for parallel computing via
\code{\link[future.apply]{future_lapply}}}

\item{future_args}{arguments passed to \code{\link[future]{plan}}; defaults
to a \code{"multisession"} with \code{supp_max} workers}

\item{...}{
  Arguments passed on to \code{\link[=abess_tram]{abess_tram}}
  \describe{
    \item{\code{supp}}{support size of the coefficient vector}
  }}
}
\value{
object of class \code{"tramvs"}, containing the regularization path
    (information criterion \code{SIC} and coefficients \code{coefs}), the
     best fit (\code{best_fit}) and all other models (\code{all_fits})
}
\description{
Select optimal subset based on high dimensional BIC
}
\details{
L0-penalized (i.e., best subset selection) transformation models
    using the abess algorithm.
}
\examples{
set.seed(24101968)
library("tramvs")

N <- 1e2
P <- 5
nz <- 3
beta <- rep(c(1, 0), c(nz, P - nz))
X <- matrix(rnorm(N * P), nrow = N, ncol = P)
Y <- 1 + X \%*\% beta + rnorm(N)

dat <- data.frame(y = Y, x = X)
res <- tramvs(y ~ ., data = dat, modFUN = Lm)
plot(res, type = "b")
plot(res, which = "path")

}
