% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors.R
\name{genemapper_table_to_fragments}
\alias{genemapper_table_to_fragments}
\title{Convert Genemapper Peak Table to fragments class}
\usage{
genemapper_table_to_fragments(
  df,
  dye_channel,
  min_size_bp = 200,
  max_size_bp = 1000
)
}
\arguments{
\item{df}{A data frame from genemapper containing the peak data.}

\item{dye_channel}{A character string indicating the Genemapper channel to extract data from. This is used to filter 'Dye.Sample.Peak' for the channel containing the data. For example, 6-FAM is often "B" while ladder is "O".}

\item{min_size_bp}{Numeric value indicating the minimum size of the peak table to import.}

\item{max_size_bp}{Numeric value indicating the maximum size of the peak table to import.}
}
\value{
A list of fragments objects.
}
\description{
This function converts a genemapper peak table data frame into a list of fragments objects.
}
\details{
This function takes a peak table data frame (eg. Genemapper 5 output) and converts it into a list of fragment objects. It uses the "Sample.File.Name" as the unique id, so make sure that each file as a unique name. Column names should contain: "Dye.Sample.Peak", "Sample.File.Name", "Allele", "Size", "Height".
}
\examples{

gm_raw <- trace::example_data

test_fragments <- genemapper_table_to_fragments(
  gm_raw,
  dye_channel = "B",
  min_size_bp = 400
)

}
\seealso{
\code{\link[=repeat_table_to_fragments]{repeat_table_to_fragments()}}, \code{\link[=size_table_to_fragments]{size_table_to_fragments()}}, \code{\link[=read_fsa]{read_fsa()}}
}
