% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.R
\name{normalise}
\alias{normalise}
\title{Normalise tally weights}
\usage{
normalise(tally)
}
\arguments{
\item{tally}{a \code{toporanga_tally} object in which weights are going to be normalised.}
}
\value{
A modified \code{toporanga_tally} object.
}
\description{
When we have \eqn{w(A\rightarrow B)=a} and \eqn{w(B\rightarrow A)=b}, this function will normalise both to sum to 1, i.e. divide by \eqn{a+b}.
This way dominance matters more than engagement in conflicts between particular agents; in particular, an agent that frequently loses in typical events but always dominate over the otherwise dominating agent will come on top with normalised weights, while remain near the bottom otherwise.
}
