% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_coloring.R
\name{map_coloring}
\alias{map_coloring}
\title{Map coloring}
\usage{
map_coloring(x, algorithm = "greedy", ncols = 8, minimize = FALSE, ...)
}
\arguments{
\item{x}{Either a shape (i.e. a \code{\link[sf:sf]{sf}} or \code{SpatialPolygons(DataFrame)} (\code{sp} package) object), or an adjacency list.}

\item{algorithm}{currently, only "greedy" is implemented.}

\item{ncols}{number of colors. By default 8.}

\item{minimize}{logical that determines whether \code{algorithm} will search for a minimal number of colors. If \code{FALSE}, the \code{ncols} colors will be picked by a random procedure.}

\item{...}{to catch deprecated arguments \code{palette} and \code{contrast}. See details.}
}
\value{
A vector of color indices.
}
\description{
Color the polygons of a map such that adjacent polygons have different colors. This function returns the color indices
}
\details{
As of tmaptools 3.3, the deprecated color functions \code{get_brewer_pal} and \code{palette_explorer}, have been removed. These have been replaced \code{c4a} and \code{c4a_gui} respectively from the package cols4all. Therefore, \code{map_coloring} will return color indices and will ignore the input arguments \code{palette} and \code{contrast}. See example.
}
\examples{
if (require(tmap) && require(cols4all)) {
    data(World)

    ## using cols4all directly
    indices <- map_coloring(World)
    pal <- c4a("brewer.set2", n = max(indices))
    World$color = pal[indices]
    tm_shape(World) +
        tm_polygons("color", fill.scale = tm_scale_asis()) +
        tm_crs("auto")

    # using map_coloring via "MAP_COLORS" in tmap
    tm_shape(World) +
        tm_polygons("MAP_COLORS", tm_scale(values = "brewer.set2")) +
        tm_crs("auto")

    # other example
    data(NLD_prov, NLD_muni)
    tm_shape(NLD_prov) +
    	tm_fill("name",
    	        fill.legend = tm_legend_hide()) +
    tm_shape(NLD_muni) +
    	tm_polygons("MAP_COLORS",
    	            fill_alpha = .25,
    	            fill.scale = tm_scale(values = "brewer.greys")) +
    tm_shape(NLD_prov) +
    	tm_borders(lwd=2) +
    	tm_text("name", options = opt_tm_text(shadow = TRUE)) +
    tm_title("Dutch provinces and\nmunicipalities", bg.color="white")
}

}
