% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_asp_ratio.R
\name{get_asp_ratio}
\alias{get_asp_ratio}
\title{Get aspect ratio}
\usage{
get_asp_ratio(x, is.projected = NA, width = 700, height = 700, res = 100)
}
\arguments{
\item{x}{A shape from class \code{\link[sf:sf]{sf}}, \code{\link[stars:st_as_stars]{stars}}, \code{sp}, or \code{Raster}, a bounding box (that can be coerced by \code{\link{bb}}), or a \code{\link[tmap:tmap-element]{tmap}} object.}

\item{is.projected}{Logical that determined wether the coordinates of \code{x} are projected (\code{TRUE}) or longitude latitude coordinates (\code{FALSE}). By deafult, it is determined by the coordinates of \code{x}.}

\item{width}{See details; only applicable if \code{x} is a \code{\link[tmap:tmap-element]{tmap}} object.}

\item{height}{See details; only applicable if \code{x} is a \code{\link[tmap:tmap-element]{tmap}} object.}

\item{res}{See details; only applicable if \code{x} is a \code{\link[tmap:tmap-element]{tmap}} object.}
}
\value{
aspect ratio
}
\description{
Get the aspect ratio of a shape object, a \code{\link[tmap:tmap-element]{tmap}} object, or a bounding box
}
\details{
The arguments \code{width}, \code{height}, and \code{res} are passed on to \code{\link[grDevices:png]{png}}. If \code{x} is a tmap object, a temporarily png image is created to calculate the aspect ratio of a tmap object. The default size of this image is 700 by 700 pixels at 100 dpi.
}
\examples{
if (require(tmap) && packageVersion("tmap") >= "2.0") {
    data(World)

    get_asp_ratio(World)

    get_asp_ratio(bb(World))

    tm <- qtm(World)
    get_asp_ratio(tm)
}

\dontrun{
    get_asp_ratio("Germany") #note: bb("Germany") uses geocode_OSM("Germany")
}
}
