% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_random.R
\name{impute_random}
\alias{impute_random}
\title{Model-free imputation via random sampling}
\usage{
impute_random(dat, reason, impute, percentile, J, seed = NULL)
}
\arguments{
\item{dat}{data.frame containing at least 5 columns: TRT01P (treatment arm as factor), AVAL (survival time), EVENT (event indicator), CNSRRS (censoring reason) and MAXAVAL (maximum potential survival time, duration between randomization to data cut-off)}

\item{reason}{a string specifying the censoring reasons which require imputation. It must be one of the reasons from variable CNSRRS.}

\item{impute}{a string specifying the treatment arm(s) which require imputation. It must be one of the arms from variable TRT01P, the first level of TRT01P is considered as the control arm.}

\item{percentile}{numeric between 1 and 100, indicating the best (or worst) percentile of subjects to sample from.}

\item{J}{numeric indicating number of imputations.}

\item{seed}{Integer. Random seed for reproducibility.}
}
\value{
a list of data.frame from each imputation with imputed AVAL and EVENT, where original variables are kept as AVALo and EVENTo.
}
\description{
randomly sample from the percentile of best or worst patients (ordered by their observed times regardless of event or censoring) who do not require imputation.
}
\details{
We define two sets of subjects to sample from depending on the \code{impute} argument:
\enumerate{
\item \strong{Worst percentile of observations from treatment arm}
\eqn{ \forall i \in N \mid \min\{T_i, C_i\} \leq F_{\min\{T_i, C_i\}}^{-1}(\kappa) }.
This set includes all indices \eqn{ i } where the minimum of \eqn{ T_i } (event time) and \eqn{ C_i } (censoring time) is \strong{less than or equal to} the \eqn{\kappa}-th percentile of its distribution.
\item \strong{Best percentile of observations control arm}
\eqn{ \forall i \in N \mid \min\{T_i, C_i\} \geq F_{\min\{T_i, C_i\}}^{-1}(\kappa) }.
This set includes all indices \eqn{ i } where the minimum of \eqn{ T_i } and \eqn{ C_i } is \strong{greater than or equal to} the \eqn{\kappa}-th percentile of its distribution.
}

where \eqn{ F(\cdot) } denotes the cumulative distribution function (CDF) of the observed times and \eqn{F^{-1}(\kappa) } is the inverse CDF (quantile function) at percentile \eqn{\kappa}.
}
\keyword{internal}
