% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic_modeling_utilities.R
\name{LabelTopics}
\alias{LabelTopics}
\title{Get some topic labels using a "more probable" method of terms}
\usage{
LabelTopics(assignments, dtm, M = 2)
}
\arguments{
\item{assignments}{A documents by topics matrix similar to \code{theta}. 
This will work best if this matrix is sparse, with only a few non-zero topics 
per document.}

\item{dtm}{A document term matrix of class \code{matrix} or \code{dgCMatrix}.
The columns of \code{dtm} should be n-grams whose colnames have a "_" where
spaces would be between the words.}

\item{M}{The number of n-gram labels you want to return. Defaults to 2}
}
\value{
Returns a \code{matrix} whose rows correspond to topics and whose
j-th column corresponds to the j-th "best" label assignment.
}
\description{
Function calls \code{\link[textmineR]{GetProbableTerms}} with some 
rules to get topic labels. This function is in "super-ultra-mega alpha"; use
at your own risk/discretion.
}
\examples{
# make a dtm with unigrams and bigrams
data(nih_sample_topic_model)

m <- nih_sample_topic_model

assignments <- t(apply(m$theta, 1, function(x){
  x[ x < 0.05 ] <- 0
  x / sum(x)
}))

assignments[is.na(assignments)] <- 0

labels <- LabelTopics(assignments = assignments, dtm = m$data, M = 2)

}
