% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trigonometry_degrees.R
\name{get_azimuth}
\alias{get_azimuth}
\title{Azimuth Between two Points}
\usage{
get_azimuth(lat_a, lon_a, lat_b, lon_b)
}
\arguments{
\item{lat_a, lat_b}{Numeric. Latitudes of a and b (in degrees).}

\item{lon_a, lon_b}{Numeric. Longitudes of a and b (in degrees).}
}
\value{
numeric. Azimuth in degrees
}
\description{
Calculate initial bearing (or forward azimuth/direction) to go
from point \code{a} to point \code{b} following great circle arc on a
sphere.
}
\details{
\code{\link[=get_azimuth]{get_azimuth()}} is based on the spherical law of tangents.
This formula is for the initial bearing (sometimes referred to as
forward azimuth) which if followed in a straight line along a great circle
arc will lead from the start point \code{a} to the end point \code{b}.
\deqn{\theta = \arctan2 (\sin \Delta\lambda
\cos\psi_2, \cos\psi_1 \sin\psi_1-\sin\psi_1 \cos\psi_2 \cos\Delta\lambda)}
where  \eqn{\psi_1, \lambda_1} is the start point, \eqn{\psi_2},
\eqn{\lambda_2} the end point (\eqn{\Delta\lambda} is the difference in
longitude).
}
\examples{
berlin <- c(52.517, 13.4) # Berlin
tokyo <- c(35.7, 139.767) # Tokyo
get_azimuth(berlin[1], berlin[2], tokyo[1], tokyo[2]) # 41.57361
}
\references{
\url{http://www.movable-type.co.uk/scripts/latlong.html}
}
