% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_rmarkdown.R
\name{.markdown_internal}
\alias{.markdown_internal}
\alias{toHTML.markdown_internal}
\alias{to_rmd.markdown_internal}
\title{Create internal markdown object for use in reporter}
\usage{
.markdown_internal(markdown_file, rendered_html)

\method{toHTML}{markdown_internal}(x, ...)

\method{to_rmd}{markdown_internal}(block, figures_dir = "figures", ...)
}
\arguments{
\item{markdown_file}{(\code{character(1)}) path to markdown file.}

\item{rendered_html}{(\code{shiny.tag}) rendered HTML content.}

\item{x}{ An object to display. }

\item{...}{Arguments that will be passed to the next method.}

\item{block}{(\code{any}) content which can be represented in Rmarkdown syntax.}

\item{figures_dir}{(\code{character(1)}) directory where the R markdown auxiliary files will be saved.}
}
\value{
\code{markdown_internal} object
}
\description{
Creates an object of class \code{markdown_internal} that contains the
content of a markdown file.
}
\details{
This package registers S3 methods for \code{toHTML} and \code{to_rmd} for this class to
facilitate rendering in \code{teal.reporter}.
}
\section{Functions}{
\itemize{
\item \code{toHTML(markdown_internal)}: Custom \code{\link[tools:toHTML]{tools::toHTML()}} method for markdown_internal class that
uses a cached rendering of the module.

\item \code{to_rmd(markdown_internal)}: Custom \code{\link[teal.reporter:to_rmd]{teal.reporter::to_rmd()}} method for \code{markdown_internal}
object will be used to render the report.

}}
\keyword{internal}
