% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param-blur-sigmas.R, R/param-hom-degree.R
\name{get_blur_range}
\alias{get_blur_range}
\alias{hom_degree}
\alias{max_hom_degree}
\alias{get_hom_range}
\title{(Maximum) topological dimension or homological degree}
\usage{
get_blur_range(object, x, ...)

hom_degree(range = c(0L, unknown()), trans = NULL)

max_hom_degree(range = c(0L, unknown()), trans = NULL)

get_hom_range(object, x, max_dim = 2L, ...)
}
\arguments{
\item{object}{A \code{param} object or a list of \code{param} objects.}

\item{x}{The predictor data. In some cases (see below) this should only
include numeric data.}

\item{...}{Other arguments to pass to the underlying parameter
finalizer functions. For example, for \code{get_rbf_range()}, the dots are passed
along to \code{\link[kernlab:sigest]{kernlab::sigest()}}.}

\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{max_dim}{Bound on the maximum dimension determined from the data.}
}
\value{
A \code{param} object or list of \code{param} objects.
}
\description{
The degree of the homology group to vectorize, or the degree at
which to stop vectorizing.
}
\details{
Topological features have whole number dimensions that determine the
degrees of homology that encode them. Any finite point cloud will have finite
topological dimension, but most practical applications exploit features of
degree at most 3.

Steps may vectorize features of a single degree (\code{hom_degree()}) or of
degrees zero through some maximum (\code{max_hom_degree()}).

In case the (maximum) degree is not provided, \code{get_hom_range()} queries each
list-column for the maximum dimension of its point cloud and returns the
smaller of this maximum and \code{max_dim} (which defaults to \code{2L}, the highest
homological degree of interest in most practical applications).
}
\examples{
# toy data set
klein_sampler <- function(n, prob = .5) {
  if (rbinom(1, 1, prob) == 0) {
    tdaunif::sample_klein_flat(n)
  } else {
    tdaunif::sample_klein_tube(n)
  }
}
sample_data <- data.frame(
  id = LETTERS[seq(4L)],
  sample = I(c(replicate(4L, klein_sampler(60), simplify = FALSE)))
)

# options to calibrate homological degree
hom_degree(range = c(2, 5))
hom_degree() \%>\% get_hom_range(x = sample_data[, 2, drop = FALSE])
hom_degree() \%>\% get_hom_range(x = sample_data[, 2, drop = FALSE], max_dim = 5)

# heterogeneous data types
hetero_data <- tibble(dataset = list(mtcars, nhtemp, eurodist, HairEyeColor))
hetero_data \%>\% 
  mutate(class = vapply(dataset, function(x) class(x)[[1L]], ""))
get_hom_range(
  hom_degree(),
  hetero_data,
  max_dim = 60
)
}
