#' @importFrom utils tail
#' @importFrom ape rtree 
#' @importFrom dplyr slice_max lag
#'
#' @title Get area in meter
#' 
#' @author Johannes De Groeve
#' @description Get the area based on an object of class tabs or recvect object 
#'
#' @param filename character. Object of class tabs, recvect (SpatVector) or path where outputs of the reconstruct-function were exported. Data exported in the following formats can be read by get_area: directory tree, .qs2 and .rds.
#' @param verbose boolean, print messages
#'
#' @return tabs object 
#'
#' @export
#' 
#' @inherit reconstruct examples
#' 
get_area <- function(filename,verbose=FALSE){
  
  if(is.character(filename)){ # if character, calculate area from an already exported object 
    reconstruction <- import(filename)
    paleov <- reconstruction$recvect
  } else {
    if(inherits(filename,'SpatVectorCollection')){
      paleov <- filename
    } else {
      # if reconstruct
      paleov <- filename$recvect  
    }
    }

paleov_df <- lapply(paleov, data.frame)
paleov_all <- do.call('rbind.data.frame',paleov_df)
unique_rec <- unique(paleov_all[,c('recid','recname','iso')])
isos <- unique(unique_rec$iso)
paleov_all <- split(paleov_all,f=paleov_all$iso)
unique_rec <- split(unique_rec, f=unique_rec$iso)

if(as.numeric(verbose) == 1) {message('3. prepare recarea')}
area_l <- list()
for(j in 1:length(unique_rec)){
    if(as.numeric(verbose) == 1) message('3.', j, '.', ' polygons with iso: ',isos[j])
    if(as.numeric(verbose) == 1) {pb <- pbar(max=length(unique_rec))} # pbar for each iso 
    unique_recid <- unique_rec[[j]]$recid
    unique_period <- unique(paleov_all[[j]]$period)
    #if('area' %in% metrics) {
    area <- matrix(nrow=length(unique_recid),
                   ncol=length(unique_period))
    colnames(area) <- unique_period
    recname_split <- lapply(paleov_all[[j]]$recnames, function(x) jsonlite::fromJSON(x)$id)
    for(i in 1:length(unique_recid)){
      recname_exists <- as.vector(unlist(lapply(recname_split,function(x) sort(grepl(paste0('^',unique_recid[i],'$'),x),decreasing=TRUE)[1])))
      paleov_sub <- paleov_all[[j]][recname_exists,]
      paleov_sub$len <- nchar(paleov_sub$recnames)
      paleov_sub <- paleov_sub[order(paleov_sub$period,paleov_sub$len),]
      paleov_sub <- paleov_sub %>% 
        group_by(.data$period) %>% 
        mutate(id=row_number()) %>% 
        arrange(.data$period,.data$len) %>% 
        filter(.data$id==1) # subset(id==1)
      
      area[i,] <- merge(data.frame(period=unique_period),paleov_sub, by='period',all=TRUE)$area
      
      if(as.numeric(verbose) > 1) message('compute area curve ',unique_rec[[j]][i,'recname'])
      if(as.numeric(verbose) == 1) {update_pbar(pb, i)}
    }
    area <- cbind(unique_rec[[j]],area)
    rownames(area) <- NULL
    area_l[[j]] <- area 
  #}
    if(as.numeric(verbose) == 1){ close(pb) }
}

area <- do.call('rbind.data.frame',area_l)
return(area)
}





# 
# library(tidytree)
# 
# # computing area based on tabs object, recvect object or an exported dataset
# 
# # load data samples
# sporades <- sporades()
# topo <- sporades$topo
# correction <- sporades$correction
# curve <- sporades$curve
# labs <- sporades$labs
# 
# dir <- tempdir() # export to temporary directory
# 
# rec <- reconstruct(topo=topo,
#                    region=labs,
#                    curve=curve,
#                    correction=correction,
#                    reclabs='name',
#                    filename=paste0(dir,'/sporades.qs2'),
#                    overwrite=TRUE)
# 
# tree <- get_tree(rec)
# tree <- get_tree(rec$recvect)
# tree <- get_tree(paste0(dir,'/sporades.qs2'))
# 
# # lapply(tree,function(x) plot(tidytree::as.phylo(x)))
# 
# # create tree for a single polygon (keeps all relations)
# tree <- get_tree(rec,name='Nisi Alonnisos')
# # plot(tidytree::as.phylo(tree[[1]]))
# 
# tree <- get_tree(paste0(dir,'/sporades.qs2'),
#                  name=c('Nisi Alonnisos','Nisida Praso'))
# # lapply(tree,function(x) plot(tidytree::as.phylo(x)))


# 
# # LIST ISLANDNAMES
# # reference islands intersecting a paleopolygon (present day existing islands)
# # paleo islands intersecting a paleopolygon
# list_islands <- function(reconstruction, reference){
#   if(reference){
#     pv <- lapply(reconstruction[[1]]$islandnstr, function(x) )
#   } else {
#     pv <- reconstruction[[1]][[i]]$paleoislandstr
#   }
# }
# 
# # islands = vector of islands to calculate metrics for
# metrics <- function(reconstruction, filename='~', islands=NULL, metrics=c('distance','distance from continent','time since isolation')){
# 
#   # INPUT DATA
#   if(is.character(reconstruction)){ # if reconstruction is loaded from computer
#     paleov <- rast(list.files(pattern='VEC',path=reconstruction))
#   } else { # reconstruct
#     paleov <- reconstruction[[1]]
#   }
# 
#   # SELECT ISLANDS OF INTEREST
#   if(is.null(islands)){
#     # bla bla
#   }
#   # DISTANCE BETWEEN ISLANDS - CAN BE DONE IN PARALLEL
#   if ('distance' %in% metrics){
#     tdir <-tempfile("METRICS_")
#     for(i in 1:length(paleov)){
#       pv <- paleov[[i]]
#       pv <- project(pv, '+proj=aeqd +lat_0=0 +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs')
#       d <- round(as.matrix(terra::distance(pv,symmetrical=FALSE)))
#       colnames(d) <- pv$paleoname
#       rownames(d) <- pv$paleoname
#       write.csv(as.data.frame(d),paste0(tdir, '/D_ISL',vecn,'.csv'))
#     }
#     zip(zipfile=paste0(filename, "_reconstruction_dist.zip"),
#         files=list.files(tdir,full.names =TRUE),
#         flags = '-r9Xj')
#   }
#   # DISTANCE FROM CONTINENT - CAN BE DONE IN PARALLEL
# 
# 
# 
# 
# }
# 
# 
