% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synthesizer.R
\name{make_synthesizer}
\alias{make_synthesizer}
\alias{make_synthesizer.numeric}
\alias{make_synthesizer.integer}
\alias{make_synthesizer.logical}
\alias{make_synthesizer.factor}
\alias{make_synthesizer.character}
\alias{make_synthesizer.ts}
\alias{make_synthesizer.data.frame}
\title{Create a function that generates synthetic data}
\usage{
make_synthesizer(x, ...)

\method{make_synthesizer}{numeric}(x, na.rm = FALSE, ...)

\method{make_synthesizer}{integer}(x, na.rm = FALSE, ...)

\method{make_synthesizer}{logical}(x, na.rm = FALSE, ...)

\method{make_synthesizer}{factor}(x, na.rm = FALSE, ...)

\method{make_synthesizer}{character}(x, na.rm = FALSE, ...)

\method{make_synthesizer}{ts}(x, ...)

\method{make_synthesizer}{data.frame}(x, na.rm = FALSE, ...)
}
\arguments{
\item{x}{\code{[vector|data.frame]} Template data to be synthesized.}

\item{...}{arguments passed to other methods}

\item{na.rm}{\code{[logical]} Remove missing values before creating a synthesizer}
}
\value{
A \code{function} accepting a single integer argument: the number
        of synthesized values or records to return.  For objects of class
        \code{ts} \code{n} must be equal to the length of the original data
        (this is set as the default).
}
\description{
Create a function that accepts a non-negative integer \code{n}, and
that returns synthetic data sampled from the emperical (multivariate)
distribution of \code{x}.
}
\examples{
synth <- make_synthesizer(cars$speed)
synth(10)


synth <- make_synthesizer(iris)
synth(6)
synth(150)
synth(250)

}
\seealso{
Other synthesis: 
\code{\link{synthesize}()}
}
\concept{synthesis}
