% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survCoxPH.R
\name{survcoxlasso_train}
\alias{survcoxlasso_train}
\title{Trains CoxLasso, using cv.glmnet(s="lambda.min")}
\usage{
survcoxlasso_train(
  df_train,
  predict.factors,
  inner_cv = 5,
  fixed_time = NaN,
  retrain_cox = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{df_train}{data frame with the data, "time" and "event" should describe survival outcome}

\item{predict.factors}{list of the column names to be used as predictors}

\item{inner_cv}{k in k-fold CV for lambda tuning}

\item{fixed_time}{not used here, for internal use}

\item{retrain_cox}{whether to re-train coxph on non-zero predictors; FALSE by default}

\item{verbose}{TRUE/FALSE prints warnings if no predictors in Lasso}
}
\value{
fitted CoxPH object with coefficient of CoxLasso or re-trained CoxPH with non-zero CoxLasso if retrain_cox = FALSE or TRUE
}
\description{
Trains CoxLasso, using cv.glmnet(s="lambda.min")
}
