% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_emergence.R
\name{probability_emergence}
\alias{probability_emergence}
\title{Calculate the probability a disease will emerge and cause a sustained
outbreak (\eqn{R > 1}) based on R and initial cases}
\usage{
probability_emergence(
  R_wild,
  R_mutant,
  mutation_rate,
  num_init_infect,
  tol = 1e-10,
  max_iter = 1000
)
}
\arguments{
\item{R_wild}{A \code{number} specifying the R parameter (i.e. average
secondary cases per infectious individual) for the wild-type pathogen.}

\item{R_mutant}{A \code{number} or vector of \code{numbers} specifying the R
parameter (i.e. average secondary cases per infectious individual) for the
mutant pathogen(s). If there is more than one value supplied to \code{R_mutant},
then the first element is the reproduction number for \eqn{m - 1} mutant
and the last element is the reproduction number for the \eqn{m} mutant
(i.e. fully evolved).}

\item{mutation_rate}{A \code{number} specifying the mutation rate (\eqn{\mu}),
must be between zero and one.}

\item{num_init_infect}{An \code{integer} (or at least
\href{https://rlang.r-lib.org/reference/is_integerish.html}{"integerish"} if
stored as double) specifying the number of initial infections.}

\item{tol}{A \code{number} for the tolerance of the numerical convergence.
Default is \code{1e-10}.}

\item{max_iter}{A \code{number} for the maximum number of iterations for the
optimisation. Default is \code{1000}.}
}
\value{
A value with the probability of a disease emerging and causing an
outbreak.
}
\description{
The method for the evolution of pathogen emergence described in
Antia et al. (2003) (\doi{10.1038/nature02104}). The model is a multi-type
branching process model with an initial (wild-type) reproduction number,
usually below 1, and a evolved reproduction number that is
greater than 1, and thus can cause a sustained human-to-human epidemic.
The reproduction number for a pathogen changes at the \code{mutation_rate}.
}
\details{
Following Antia et al. (2003), we assume that the mutation rate for all
variants is the same.
}
\examples{
probability_emergence(
  R_wild = 0.5,
  R_mutant = 1.5,
  mutation_rate = 0.5,
  num_init_infect = 1
)
}
\references{
Antia, R., Regoes, R., Koella, J. & Bergstrom, C. T. (2003)
The role of evolution in the emergence of infectious diseases.
Nature 426, 658–661. \doi{10.1038/nature02104}
}
\seealso{
\code{\link[=probability_epidemic]{probability_epidemic()}}, \code{\link[=probability_extinct]{probability_extinct()}}
}
