% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_call.R
\name{parse_call}
\alias{parse_call}
\title{Extract Data Information From Arguments Passed to Functions (internal)}
\usage{
parse_call(
  mc,
  var = "x",
  df_name = TRUE,
  df_label = TRUE,
  var_name = TRUE,
  var_label = TRUE,
  caller = "",
  silent = TRUE
)
}
\arguments{
\item{var}{Character. \dQuote{x} (default) or \dQuote{y} (the latter 
being used only in \code{\link{ctable}}).}

\item{df_name}{Logical.}

\item{df_label}{Logical.}

\item{var_name}{Logical.}

\item{var_label}{Logical.}

\item{silent}{Logical. Hide console messages. \code{TRUE} by default.}
}
\value{
A list consisting of one or many of the following items
\itemize{
  \item df_name The data frame name
  \item df_label The data frame label
  \item var_name The variable name(s)
  \item var_label The variable label
  \item by_var The variable used in \code{by()}, when in the call stack
  \item by_group The group, when \code{by()} was used
  \item by_first Binary indicator used when \code{by()} is in the call stack
  \item by_last Binary indicator}
}
\description{
Using sys.calls(), sys.frames() and match.call(), this utility function
extracts and/or infers information about the data being processed.
Data frame name, variable names and labels if any, subsetting information,
grouping information (when by() is used) are returned by the function which
tries various methods to get this information.
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{internal}
\keyword{misc}
