% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.summarytools.R
\name{print.summarytools}
\alias{print.summarytools}
\title{print.summarytools}
\usage{
\method{print}{summarytools}(x, method = "pander", file = "",
   append = FALSE, report.title = NA, table.classes = NA,
   bootstrap.css = st_options('bootstrap.css'),
   custom.css = st_options('custom.css'), silent = FALSE,
   footnote = st_options('footnote'), max.tbl.height = Inf,
   collapse = 0, escape.pipe = st_options("escape.pipe"), \dots)
}
\arguments{
\item{x}{A \emph{summarytools} object, created by one of the four core
functions (\code{\link{freq}}, \code{\link{descr}}, \code{\link{ctable}},
or \code{\link{dfSummary}}).}

\item{method}{Character. One of \dQuote{pander}, \dQuote{viewer}, 
\dQuote{browser}, or \dQuote{render}. Default value for the \code{print()}
method is \dQuote{pander}; for \code{view()}/\code{stview()}, default is
\dQuote{viewer} if session is running in \emph{RStudio}, \dQuote{browser}
otherwise. The main use for \dQuote{render} is in \emph{R Markdown}
documents.}

\item{file}{Character. File name to write output to. Defaults to \dQuote{}.}

\item{append}{Logical. Append output to existing file (specified using the
\emph{file} argument). \code{FALSE} by default.}

\item{report.title}{Character. For \emph{html} reports, this goes into the
\code{<title>} tag. When left to \code{NA} (default), the first line of the
heading section is used (\emph{e.g.}: \dQuote{Data Frame Summary}).}

\item{table.classes}{Character. Additional \emph{html} classes to assign to
output tables. \emph{Bootstrap css} classes can be used. User-defined
classes (see the \emph{custom.css} argument) are also specified here. See
\emph{details} section. \code{NA} by default.}

\item{bootstrap.css}{Logical. When generating an \emph{html} document, 
include the \dQuote{\emph{includes/stylesheets/bootstrap.min.css"}} file
content inside a \code{<style type="text/css">} tag in the document's
\code{<head>}. \code{TRUE} by default. Can be set globally with 
\code{\link{st_options}}.}

\item{custom.css}{Character. Path to a custom \emph{.css} file. Classes
defined in this must also appear in the \code{table.classes} parameter
in order to be applied to the table(s). Can be set globally with
\code{\link{st_options}}. \code{NA} by default.}

\item{silent}{Logical. Set to \code{TRUE} to hide console messages 
(\emph{e.g.}: ignored variables or \code{NaN} to \code{NA}
transformations). \code{FALSE} by default.}

\item{footnote}{Character. Text to display just after \emph{html} output
tables. The default value (\dQuote{\emph{default}}) produces a two-line
footnote indicating the package's name and version, the R version, and
the current date. Has no effect on \emph{ascii} or \emph{markdown}
content. Can contain standard \emph{html} tags. Set to \code{NA} to omit.
Can be set globally with \code{\link{st_options}}.}

\item{max.tbl.height}{Numeric. Maximum table height \emph{in pixels} allowed
in rendered \code{dfSummary()} tables. When this argument is used, results 
will show up in a \code{<div>} with the specified height and a scroll bar.
Intended to be used in \emph{Rmd} documents with \code{method = "render"}.
\code{Inf} by default.}

\item{collapse}{Numeric. \code{0} by default. Set to \code{1} to make
\code{freq()} sections collapsible (when clicking on the variable name).
Future versions might provide alternate collapsing options.}

\item{escape.pipe}{Logical. Set to \code{TRUE} when \code{style="grid"}
and \code{file} argument is supplied if the intent is to generate a text
file that can be converted to other formats using \emph{Pandoc}. Can be
set globally with \code{\link{st_options}}.}

\item{\dots}{Additional arguments used to override attributes stored in the
object, or to change formatting via \code{\link[base]{format}} or 
\code{\link[pander]{pander}}. See \emph{Details}.}
}
\value{
\code{NULL} when \code{method="pander"}; A file path returned
  invisibly when \code{method="viewer"} or \code{"browser"}. In the
  latter case, the file path is also passed to \code{shell.exec} 
  (\emph{Windows}) or \code{\link{system}} (\emph{*nix}), causing
  the document to be opened in default Web browser.
}
\description{
Display \code{summarytools} objects in the console, in Web Browser or in
 \emph{RStudio}'s Viewer, or write content to file.
}
\details{
\code{Ascii} and \emph{markdown} tables are generated using
  \code{\link[pander]{pander}}. 

The following arguments can be used to override formatting attributes stored
in the object:
   \itemize{
     \item \code{style}
     \item \code{round.digits} (except for \emph{dfSummary} objects)
     \item \code{plain.ascii}
     \item \code{justify}
     \item \code{split.tables}
     \item \code{headings}
     \item \code{display.labels}
     \item \code{varnumbers}    (\code{\link{dfSummary}} objects only)
     \item \code{labels.col}    (\code{\link{dfSummary}} objects only)
     \item \code{graph.col}     (\code{\link{dfSummary}} objects only)
     \item \code{valid.col}     (\code{\link{dfSummary}} objects only)
     \item \code{na.col}        (\code{\link{dfSummary}} objects only)
     \item \code{col.widths}    (\code{\link{dfSummary}} objects only)
     \item \code{keep.grp.vars} (\code{\link{dfSummary}} objects only)
     \item \code{report.nas}    (\code{\link{freq}} objects only)
     \item \code{display.type}  (\code{\link{freq}} objects only)
     \item \code{missing}       (\code{\link{freq}} objects only)
     \item \code{totals}        (\code{\link{freq}} and \code{\link{ctable}} objects)
     \item \code{caption}       (\code{\link{freq}} and \code{\link{ctable}} objects)
   }

The following arguments can be used to override heading elements:

   \itemize{
     \item \code{Data.frame}
     \item \code{Data.frame.label}
     \item \code{Variable}
     \item \code{Variable.label}
     \item \code{Group}
     \item \code{date}
     \item \code{Weights}   (\code{\link{freq}} & \code{\link{descr}} objects)
     \item \code{Data.type} (\code{\link{freq}} objects only)
     \item \code{Row.variable} (\code{\link{ctable}} objects only)
     \item \code{Col.variable} (\code{\link{ctable}} objects only)
   }
}
\examples{
\dontrun{
data(tobacco)
view(dfSummary(tobacco), footnote = NA)
}
data(exams)
print(freq(exams$gender), style = 'rmarkdown')
print(descr(exams), headings = FALSE)

}
\references{
\href{https://github.com/dcomtois/summarytools/}{Summarytools on GitHub}
\href{http://rapporter.github.io/pander/#general-options/}{List of pander options}
\href{https://getbootstrap.com/docs/4.3/getting-started/introduction/}{Bootstrap Cascading Stylesheets}
}
\seealso{
\code{\link[pander]{pander}}
}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{methods}
\keyword{print}
