% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{\%nin\%}
\alias{\%nin\%}
\title{Find Non-Matching Elements}
\usage{
a \%nin\% b
}
\arguments{
\item{a}{a vector (character, factor, or numeric)}

\item{b}{a vector (character, factor, or numeric)}
}
\value{
\code{\%nin\%} finds non-matching elements and returns one of two things, depending on the use. For two simple vectors,
it will report what matches and what does not. For comparing a vector within a data frame, it has the effect of reporting the rows
in the data frame that do not match the supplied (second) vector.
}
\description{
\code{\%nin\%} finds non-matching elements in a given vector. It is the negation of \code{\%in\%}.
}
\details{
This is a simple negation of \code{\%in\%}. I use it mostly for columns in a data frame.
}
\examples{

library(tibble)
library(dplyr)

# Watch this subset stuff

dat <- tibble(x = seq(1:10), d = rnorm(10))
filter(dat, x \%nin\% c(3, 6, 9))

}
