% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{summary.staged_tree}
\alias{summary.staged_tree}
\title{Summarise a Staged Tree Object}
\usage{
\method{summary}{staged_tree}(object, ...)
}
\arguments{
\item{object}{An object of class \code{staged_tree}, containing components \code{nodes} and \code{edges} in \code{object$stagedtree$x}, and optionally a \code{priortable}.}

\item{...}{Additional arguments (currently unused).}
}
\value{
Invisibly returns a list containing summary components:
\itemize{
\item \code{num_nodes}: Total number of nodes in the staged tree.
\item \code{num_edges}: Total number of edges in the staged tree.
\item \code{num_uncoloured_middle}: Number of white nodes not in the first or last level.
\item \code{color_counts}: A named table of node colour frequencies.
\item \code{priortable}: The prior table, if available; otherwise \code{NULL}.
}
Also prints a human-readable summary to the console.
}
\description{
Provides a visual and textual summary of a staged tree object, including counts of nodes and edges, node colour distributions, and uncoloured nodes in intermediate levels.
}
\details{
This function #prints a summary that includes:
\itemize{
\item Total number of nodes and edges.
\item Number of nodes still uncoloured (white) that are not in the first or last level.
\item A count of nodes by hex colour, optionally with coloured terminal output using the \code{crayon} package.
\item The prior table if it exists.
}

If the \code{crayon} package is available, the function displays background colour blocks in the console to represent node colours.
}
\note{
White-coloured nodes (\verb{#FFFFFF}) that are not in the minimum or maximum level are flagged as "Nodes left to be coloured."
}
\examples{
data <- homicides
event_tree <- create_event_tree(data, columns = c(1,2,4,5), "both")
coloured_tree <- ahc_colouring(event_tree)
tree_priors <- specify_priors(coloured_tree, prior_type = "Uniform", ask_edit = FALSE)
staged_tree <- staged_tree_prior(coloured_tree, tree_priors)
homicides_ST_summary <- summary(staged_tree)

}
