% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellMGGMM.R
\name{cellMGGMM}
\alias{cellMGGMM}
\title{Calculation of the cellwise robust multi-group Gaussian mixture model}
\usage{
cellMGGMM(
  X,
  groups,
  alpha = 0.5,
  hperc = 0.75,
  nsteps = 100,
  crit = 1e-04,
  silent = TRUE,
  maxcond = 100
)
}
\arguments{
\item{X}{A numeric matrix or data frame with observations in rows and variables in columns.}

\item{groups}{A vector indicating the group membership for each observation (length must match `nrow(X)`).}

\item{alpha}{A non-negative numeric value between `0.5` and `1` controlling the flexibility degree. Default is `0.5`.}

\item{hperc}{A numeric value in `[0,1]` controlling robustness of the estimation. Default is `0.75`.}

\item{nsteps}{Number of main iteration steps in the algorithm. Default is `100`.}

\item{crit}{Convergence criterion for iterative updates. Default is `1e-4`.}

\item{silent}{Logical; if `TRUE`, suppresses progress output. Default is `FALSE`.}

\item{maxcond}{Maximum allowed condition number for covariance matrices. Default is `100`.}
}
\value{
A list containing: \describe{
  \item{\code{X}}{The original data matrix.}
  \item{\code{Ximp}}{The imputed and/or scaled data matrix.}
  \item{\code{groups}}{Vector specifying group assignments from the input.}
  \item{\code{class}}{Vector indicating the most likely group membership for each observation, as inferred by the model.}
  \item{\code{mu}}{A list of estimated location (mean) vectors for each group.}
  \item{\code{Sigma}}{A list of estimated covariance matrices for each group.}
  \item{\code{Sigmai}}{A list of estimated inverse covariance matrices for each group.}
  \item{\code{probs}}{A matrix of class probabilities for each observation (rows = observations, columns = groups).}
  \item{\code{pi_groups}}{A matrix of estimated mixture probabilities, where rows correspond to groups and columns to distributions.}
  \item{\code{W}}{A binary matrix indicating outlying cells (0 = outlier, 1 = no outlier).}
  \item{\code{Q}}{A matrix of penalty weights.}
  \item{\code{Sigma_reg}}{A list of estimated target (regularization) matrices.}
  \item{\code{rho}}{A vector of regularization factors used in the estimation.}
  \item{\code{alpha}}{Flexibility parameter, as provided in the function input.}
  \item{\code{hperc}}{A matrix or vector indicating the percentage of outlying cells per variable and group, based on input.}
  \item{\code{nsteps}}{The number of iteration steps taken until convergence.}
  \item{\code{objvals}}{The values of the objective function across the iteration steps.}
}
}
\description{
Performs robust estimation of multivariate location and scatter within predefined groups
using an iiterative EM-based algorithm.
}
\examples{
data("weatherAUT2021")
cut_lon = c(min(weatherAUT2021$lon)-0.2, 12, 16, max(weatherAUT2021$lon) + 0.2)
cut_lat = c(min(weatherAUT2021$lat)-0.2, 48, max(weatherAUT2021$lat) + 0.2)
groups = groups_gridbased(weatherAUT2021$lon, weatherAUT2021$lat, cut_lon, cut_lat)
N = length(unique(groups))
model = cellMGGMM(X = weatherAUT2021[, c("p", "s", "vv", "t", "rsum", "rel")],
                 groups = groups,
                 alpha = 0.5)
}
\references{
Puchhammer, P., Wilms, I., & Filzmoser, P. (2025). A smooth multi-group Gaussian Mixture Model for cellwise robust covariance estimation. \emph{ArXiv preprint} \doi{10.48550/arXiv.2504.02547}.
}
\seealso{
\code{\link[ssMRCD]{residuals_mggmm}}
}
