% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{historyStack}
\alias{historyStack}
\title{history stack structure and methods}
\value{
an R6 class object
}
\description{
Some methods for a history stack data structure. It can store history
of certain repeating actions. For example, building the back-end of a file/image
editor, allow undo/redo actions.
}
\details{
1. If the stack reaches the limit and you are trying to add more history, the
   first history step will be removed , all history will be shift to the left
   by one step and finally add the new step to the end.
2. When history returning methods are called, like the `get()`, `forward()`, `backward()`
   methods, it will not directly return the item saved, but a list, contains 4
   components: 1. item, the actual item stored; 2. pos, current posistion value;
   3. first, boolean value, if this history is stored on the first position of stack;
   4. last, boolean value, if this history is stored on the last position of stack;
3. If you `forward` beyond last step, or `backward` to prior the first
   step, it will be stopped with errors.
4. Starting  history stack with no initial history will return a special
   stack, where the `pos = 0`, `len = 0`, `first = TRUE`, and `last = TRUE`.
   This means you cannot move forward or backward. When you `get()`, it will be
   an empty list `list()`. After adding any new history, `pos` will never be
   0 again, it will always be a larger than 0 value.
}
\examples{
his <- historyStack$new()
# add some history
his$add(1)
his$add(2)
his$add(3)
his$add(4)
his$add(5)
# check status
his$status()
# get item at current history position
his$get()
# go back to previous step
his$backward()
# going back to step 2
his$backward()
his$backward()
# going forward 1 step tp step 3
his$forward()
# check current status
his$status()
# adding a new step at position 3 will remove the old step 4,5 before adding
his$add("new 4")
# only 3 steps + 1 new step = 4 steps left
his$status()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-historyStack-new}{\code{historyStack$new()}}
\item \href{#method-historyStack-clear}{\code{historyStack$clear()}}
\item \href{#method-historyStack-get}{\code{historyStack$get()}}
\item \href{#method-historyStack-getPos}{\code{historyStack$getPos()}}
\item \href{#method-historyStack-status}{\code{historyStack$status()}}
\item \href{#method-historyStack-forward}{\code{historyStack$forward()}}
\item \href{#method-historyStack-backward}{\code{historyStack$backward()}}
\item \href{#method-historyStack-add}{\code{historyStack$add()}}
\item \href{#method-historyStack-clone}{\code{historyStack$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-new"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-new}{}}}
\subsection{Method \code{new()}}{
create the history object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$new(items = NULL, limit = 25, verbose = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{items}}{list, initial history step items to store on start}

\item{\code{limit}}{int, how many history steps can be stored in the stack,
default 25 steps}

\item{\code{verbose}}{bool, print some verbose message?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-clear"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-clear}{}}}
\subsection{Method \code{clear()}}{
clear all history steps in the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-get"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-get}{}}}
\subsection{Method \code{get()}}{
retrieve the history from a certain position in the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$get(pos = private$pos)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pos}}{int, which position to get the history from, default is current
step.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-getPos"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-getPos}{}}}
\subsection{Method \code{getPos()}}{
get current step position in the history stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$getPos()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-status"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-status}{}}}
\subsection{Method \code{status()}}{
print out some status of the stack
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$status()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
returns a list of `pos`: current position (int); `len`: current
length of the history stack (int); `limit`: history stack storing limit (int);
`first`: is current step position the first of the stack (bool);
`last`: is current step position the last of the stack (bool)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-forward"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-forward}{}}}
\subsection{Method \code{forward()}}{
move one step forward in the history stack and return item
in that position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$forward()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-backward"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-backward}{}}}
\subsection{Method \code{backward()}}{
move one step backward in the history stack and return item
in that position
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$backward()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-add"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-add}{}}}
\subsection{Method \code{add()}}{
Add an item to the history and move one step forward
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$add(item)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{item}}{any object you want to add to the stack. Everything store
in the item will be moved into a list, so even if item may be something
length > 1, it will still be treated as a single item and single history
step.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If current position is not the last position, and when a new
step item is added to the stack, all history records (items) after current
position will be removed before adding the new history item.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-historyStack-clone"></a>}}
\if{latex}{\out{\hypertarget{method-historyStack-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{historyStack$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
