% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{vcov.abrm}
\alias{vcov.abrm}
\title{Variance-covariance method for abrm objects
Extracts variance-covariance matrices for regression coefficients from 
MCMC posterior samples. Returns separate matrices for X-grid and Y-grid
coefficients.}
\usage{
\method{vcov}{abrm}(object, ...)
}
\arguments{
\item{object}{An abrm object from run_abrm()}

\item{...}{Additional arguments (unused)}
}
\value{
A list with class "vcov.abrm" containing:
  \item{vcov_beta_x}{Variance-covariance matrix for X-grid coefficients}
  \item{vcov_beta_y}{Variance-covariance matrix for Y-grid coefficients}
  \item{vcov_beta_0}{Variance of the intercept (scalar)}
  \item{vcov_all}{Combined variance-covariance matrix for all parameters}
}
\description{
Variance-covariance method for abrm objects
Extracts variance-covariance matrices for regression coefficients from 
MCMC posterior samples. Returns separate matrices for X-grid and Y-grid
coefficients.
}
\details{
The variance-covariance matrices are computed from the posterior samples
of the MCMC chains. If multiple chains were run, samples are combined
across chains before computing covariances.
}
\examples{
\dontrun{
# Fit model
results <- run_abrm(...)

# Get variance-covariance matrices
vcov_mats <- vcov(results)

# Access specific matrices
vcov_mats$vcov_beta_x  # Covariance for X-grid coefficients
vcov_mats$vcov_beta_y  # Covariance for Y-grid coefficients

# Compute standard errors from diagonal
sqrt(diag(vcov_mats$vcov_beta_x))

# Compute correlation matrix
cov2cor(vcov_mats$vcov_beta_y)
}
}
