% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pattern.R
\docType{data}
\name{SEM_VER_PATTERN}
\alias{SEM_VER_PATTERN}
\title{A suggested regular expression (RegEx) to check a SemVer string}
\format{
An object of class \code{character} of length 1.
}
\usage{
SEM_VER_PATTERN
}
\value{
Single string
}
\description{
This is a suggested regular expression (RegEx) to check a SemVer string,
without the \code{"^"} at the start and \code{"$"} at the end.
It is useful to extract the SemVer components from VCS tags etc.
}
\examples{
SEM_VER_PATTERN

# VCS tag names often have a "v" prefix to SemVer
tag_names <- c("v1.0.0", "v1.1.0-alpha.1", "v1.1.0+build.1", "not-a-version")

# Extract and parse SemVer
regmatches(tag_names, m = regexpr(SEM_VER_PATTERN, tag_names)) |>
  parse_semver()
}
\keyword{datasets}
