% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genDataDensity}
\alias{genDataDensity}
\title{Generate data from a density defined by a vector of integers}
\usage{
genDataDensity(
  n,
  dataDist,
  varname,
  uselimits = FALSE,
  id = "id",
  na.rm = TRUE
)
}
\arguments{
\item{n}{Integer. Number of samples to draw from the density.}

\item{dataDist}{Numeric vector. Defines the desired density.}

\item{varname}{Character. Name of the variable.}

\item{uselimits}{Logical. If TRUE, the minimum and maximum of the input data 
vector are used as limits for sampling. Defaults to FALSE, in which case a 
smoothed density that extends beyond these limits is used.}

\item{id}{Character. A string specifying the field that serves as the record ID. The
default field is "id".}

\item{na.rm}{Logical. If TRUE (default), missing values in `dataDist` are 
removed. If FALSE, the data will retain the same proportion of missing values.}
}
\value{
A data table with the generated data
}
\description{
Data are generated from an a density defined by a vector of integers
}
\examples{
data_dist <- c(1, 2, 2, 3, 4, 4, 4, 5, 6, 6, 7, 7, 7, 8, 9, 10, 10)

genDataDensity(500, data_dist, varname = "x1", id = "id")
genDataDensity(500, data_dist, varname = "x1", uselimits = TRUE, id = "id")
}
\concept{generate_data}
