% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_boin.R
\name{sim_boin}
\alias{sim_boin}
\title{Run BOIN Simulation with Operating Characteristics}
\usage{
sim_boin(
  n_trials = 10000,
  target,
  p_true,
  n_cohort,
  cohort_size,
  p_saf = NULL,
  p_tox = NULL,
  n_earlystop = 18,
  cutoff_eli = 0.95,
  extrasafe = FALSE,
  offset = 0.05,
  n_earlystop_rule = "with_stay",
  titration = FALSE,
  min_mtd_sample = 1,
  boundMTD = FALSE,
  return_details = FALSE,
  verbose = FALSE,
  seed = 123
)
}
\arguments{
\item{n_trials}{Numeric. Number of trials to simulate. Default is 10000.}

\item{target}{Numeric. Target toxicity probability (e.g., 0.30 for 30\%).}

\item{p_true}{Numeric vector. True toxicity probabilities for each dose.}

\item{n_cohort}{Numeric. Maximum number of cohorts per trial.}

\item{cohort_size}{Numeric vector or scalar. Patients per cohort.}

\item{p_saf}{Numeric. Highest toxicity probability deemed acceptable for safety.
Default is 0.6 * target. Used with p_tox for safety/efficacy dose identification.}

\item{p_tox}{Numeric. Lowest toxicity probability deemed unacceptable for toxicity.
Default is 1.4 * target. Used with p_saf for safety/efficacy dose identification.}

\item{n_earlystop}{Numeric. Sample size triggering early stopping. Default is 18.}

\item{cutoff_eli}{Numeric. Cutoff probability for dose elimination. Default is 0.95.}

\item{extrasafe}{Logical. Apply extra safety stopping rule at lowest dose. Default is FALSE.}

\item{offset}{Numeric. Offset for safety cutoff when extrasafe = TRUE. Default is 0.05.}

\item{n_earlystop_rule}{Character. Early stopping rule: "with_stay" or "simple". Default is "with_stay".}

\item{titration}{Logical. Perform accelerated dose titration phase. Default is FALSE.}

\item{min_mtd_sample}{Numeric. Minimum patients required for MTD consideration. Default is 1.}

\item{boundMTD}{Logical. Impose constraint that MTD's isotonic estimate <= lambda_d. Default is FALSE.}

\item{return_details}{Logical. If TRUE, return detailed trial-level results. If FALSE, return summary only. Default is FALSE.}

\item{verbose}{Logical. If TRUE, print progress messages to console. If FALSE, run silently. Default is FALSE.}

\item{seed}{Numeric. Random seed for reproducibility. Default is 123.}
}
\value{
A list containing:
\item{detailed_results}{List of length n_trials (if return_details = TRUE).
Each element contains: n_pts, n_tox, mtd, iso_est, reason, cohorts_completed.
NULL if return_details = FALSE.}
\item{summary}{Object of class "boin_summary" containing:
p_true (true toxicity probabilities),
mtd_selection_percent (MTD selection rate for each dose and percent with no MTD),
avg_n_pts (average patients per dose),
avg_n_tox (average DLTs per dose),
avg_total_n_pts (average total patients per trial),
avg_total_n_tox (average total DLTs per trial).}
}
\description{
Execute multiple BOIN trial simulations and compute operating characteristics.
Combines patient enrollment, toxicity tracking, isotonic regression, and MTD
selection into a single streamlined function.
}
\details{
The function executes the following workflow:
\enumerate{
\item Generate patient enrollment and toxicity data via \code{\link{get_pts_and_tox}}
\item Apply isotonic regression via \code{\link{isotonic_regression}}
\item Select MTD via \code{\link{select_mtd}}
\item Compute operating characteristics (MTD selection rates, sample sizes, DLT counts)
}

Progress messages are printed to console only if verbose = TRUE.
If return_details = TRUE, detailed trial-level results are returned;
otherwise, only summary statistics are computed for efficiency.
}
\examples{
\donttest{
# Basic BOIN simulation (silent mode)
result <- sim_boin(
  n_trials = 10000,
  target = 0.30,
  p_true = c(0.10, 0.25, 0.40, 0.55, 0.70),
  n_cohort = 10,
  cohort_size = 3,
  seed = 123
)

# With progress messages
result_verbose <- sim_boin(
  n_trials = 10000,
  target = 0.30,
  p_true = c(0.10, 0.25, 0.40, 0.55, 0.70),
  n_cohort = 10,
  cohort_size = 3,
  verbose = TRUE,
  seed = 123
)
}

}
\references{
Liu S. and Yuan, Y. (2015). Bayesian Optimal Interval Designs for Phase I Clinical
Trials. Journal of the Royal Statistical Society: Series C, 64, 507-523.
}
