% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkTVP_forc}
\alias{plot.shrinkTVP_forc}
\title{Graphical summary of posterior predictive density}
\usage{
\method{plot}{shrinkTVP_forc}(x, showgap = FALSE, ...)
}
\arguments{
\item{x}{a \code{shrinkTVP_forc} object.}

\item{showgap}{if \code{showgap = FALSE}, the gap between the historical observations and the forecasts is removed.
The default value is \code{FALSE}.}

\item{...}{further arguments to be passed to \code{plot}.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{plot.shrinkTVP_forc} generates plots visualizing the posterior predictive density generated by \code{forecast_shrinkTVP}.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVP()

train <- sim$data[1:190, ]
test <- sim$data[191:200, ]

res <- shrinkTVP(y ~ x1 + x2, train)

forecast <- forecast_shrinkTVP(res, test)
plot(forecast)
lines(sim$data$y, col = "forestgreen")

}
}
\seealso{
Other plotting functions: 
\code{\link{plot.mcmc.tvp}()},
\code{\link{plot.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
