% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_cast.R
\name{st_cast}
\alias{st_cast}
\alias{st_cast.sftime}
\title{Cast geometry to another type: either simplify, or cast explicitly}
\usage{
\method{st_cast}{sftime}(x, to, ..., warn = TRUE, do_split = TRUE)
}
\arguments{
\item{x}{An object of class \code{sftime}.}

\item{to}{character; target type, if missing, simplification is tried; when \code{x} is of type \code{sfg} (i.e., a single geometry) then \code{to} needs to be specified.}

\item{...}{ignored}

\item{warn}{logical; if \code{TRUE}, warn if attributes are assigned to sub-geometries}

\item{do_split}{logical; if \code{TRUE}, allow splitting of geometries in sub-geometries}
}
\value{
\code{x} with changed geometry type.
}
\description{
Cast geometry to another type: either simplify, or cast explicitly
}
\examples{
# cast from POINT to LINESTRING
g <- st_sfc(st_point(1:2), st_point(c(2, 4)))
time <- Sys.time()
x <- 
  st_sftime(a = 3:4, g, time = time) \%>\%
  dplyr::group_by(time) \%>\%
  dplyr::summarize(do_union = TRUE) \%>\%
  st_cast(to = "LINESTRING")
}
