% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqTrans.R
\name{seqTrans}
\alias{seqTrans}
\title{Spotting impossible transitions in longitudinal categorical data}
\usage{
seqTrans(data, var = NULL, trans)
}
\arguments{
\item{data}{a data frame containing sequences of a multinomial
variable with missing data (coded as \code{NA})}

\item{var}{the list of columns containing the trajectories.
Default is NULL, i.e. all the columns.}

\item{trans}{\code{character} vector gathering the impossible transitions.
For example: trans <- c("1->3","1->4","2->1","4->1","4->3")}
}
\value{
It returns a matrix where each row is the position of an
impossible transition.
}
\description{
The purpose of \code{seqTrans} is to spot impossible transitions
in longitudinal categorical data.
}
\examples{
data(gameadd)

seqTransList <- seqTrans(data = gameadd, var = 1:4, trans = c("yes->no"))

}
\author{
Andre Berchtold and Kevin Emery
}
