% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupAndRename.R
\docType{methods}
\name{groupAndRename}
\alias{groupAndRename}
\title{Join levels of a variables in an object of class
\code{\link{sdcMicroObj-class}} or \code{factor} or \code{data.frame}}
\usage{
groupAndRename(obj, var, before, after, addNA = FALSE)
}
\arguments{
\item{obj}{object of class \code{\link{sdcMicroObj-class}}}

\item{var}{name of the keyVariable to change}

\item{before}{vector of levels before recoding}

\item{after}{name of new level after recoding}

\item{addNA}{logical, if TRUE missing values in the input variables are added to the level specified in argument \code{after}.}
}
\value{
the modified \code{\link{sdcMicroObj-class}}
}
\description{
If the input is an object of class \code{\link{sdcMicroObj-class}}, the
specified factor-variable is recoded into a factor with less levels and
risk-measures are automatically recomputed.
}
\details{
If the input is of class \code{data.frame}, the result is a \code{data.frame} with
a modified column specified by \code{var}.

If the input is of class \code{factor}, the result is a \code{factor} with different
levels.
}
\examples{
## for objects of class sdcMicro:
data(testdata2)
testdata2$urbrur <- as.factor(testdata2$urbrur)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- groupAndRename(sdc, var="urbrur", before=c("1","2"), after=c("1"))
}
\references{
Templ, M. and Kowarik, A. and Meindl, B. 
Statistical Disclosure Control for Micro-Data Using the R Package sdcMicro. 
\emph{Journal of Statistical Software}, \strong{67} (4), 1--36, 2015. \doi{10.18637/jss.v067.i04}

Templ, M. Statistical Disclosure Control for Microdata: Methods and Applications in R.
\emph{Springer International Publishing}, 287 pages, 2017. ISBN 978-3-319-50272-4. \doi{10.1007/978-3-319-50272-4}
\doi{10.1007/978-3-319-50272-4}
}
\author{
Bernhard Meindl
}
\keyword{methods}
