% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_theme.R
\name{new_theme}
\alias{new_theme}
\alias{extract_theme}
\title{Create a new scplot theme object}
\usage{
new_theme()

extract_theme(object)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}
}
\value{
An object of class \code{scplot-theme} which can be used with the
\code{\link[=set_theme]{set_theme()}} function.
}
\description{
\code{new_theme()} creates a new theme object for use with scplot.

\code{extract_theme()} extracts the theme from an existing scplot object, allowing
users to reuse or modify the theme for other scplot visualizations.
}
\details{
Themes control the overall appearance of scplot visualizations, including
colors, fonts, line styles, and layout options. By creating a custom theme,
users can ensure consistent styling across multiple plots and tailor the
visualizations to their specific needs or branding requirements.
}
\examples{
data(exampleABC, package = "scan")
my_theme <- new_theme() |>
  set_panel(color = "red")  |>
  set_base_text(size = 12, color = "blue")  |>
  set_dataline(color = "darkred", linewidth = 2)
p1 <- scplot(exampleABC)  |> set_theme(my_theme)
}
