% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_text.R
\name{add_text}
\alias{add_text}
\title{Add test to an scplot object}
\usage{
add_text(
  object,
  label,
  case = 1,
  x,
  y,
  color = "black",
  size = 1,
  angle = 0,
  hjust = 0.5,
  vjust = 0.5,
  face = 1
)
}
\arguments{
\item{object}{An scplot object (class \code{scplot}) returned from the \code{scplot()}
function.}

\item{label}{A Character vector with text labels.}

\item{case}{Numerical vector with the case number or character string. \code{case = "all"} for all cases.}

\item{x}{x position.}

\item{y}{y position.}

\item{color}{A character string or a number defining the color of an element.}

\item{size}{Text size relative to the base text size.}

\item{angle}{Angle (in [0,360])}

\item{hjust}{Horizontal justification (in [0,1])}

\item{vjust}{Vertical justification (in [0,1])}

\item{face}{Font face (\verb{"plain", "italic", "bold", "bold.italic"})}
}
\value{
An object of class \code{scplot} (see\code{\link[=scplot]{scplot()}}) with a changed \code{texts}
element.
}
\description{
Adds a text element to an \code{scplot} object at specified coordinates.
}
