% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cppad_closed.R
\name{cppad_closed}
\alias{cppad_closed}
\title{Score Matching Estimator for Quadratic-Form Score Matching Discrepancies}
\usage{
cppad_closed(
  smdtape,
  Y,
  Yapproxcentres = NA * Y,
  w = rep(1, nrow(Y)),
  approxorder = 10
)
}
\arguments{
\item{smdtape}{A tape (\code{\link{Rcpp_ADFun}} object) of a score matching discrepancy function that has \emph{quadratic form}. Test for quadratic form using \code{\link[=testquadratic]{testquadratic()}}.
The \code{smdtape}'s independent variables are assumed to be the model parameters to fit
and the \code{smdtape}'s dynamic parameter is a (multivariate) measurement.}

\item{Y}{A matrix of multivariate observations. Each row is an observation. The number of columns of \code{Y} must be \code{smdtape$size_dyn_ind}.}

\item{Yapproxcentres}{A matrix of Taylor approximation centres for rows of Y that require approximation. \code{NA} for rows that do not require approximation.}

\item{w}{Weights for each observation.}

\item{approxorder}{The order of Taylor approximation to use.}
}
\description{
For a tape of a quadratic-form score matching discrepancy function, calculates the vector of parameters such that the gradient of the score matching discrepancy is zero.
Also estimates standard errors and covariance.
Many score matching discrepancy functions have a quadratic form (see \code{\link{scorematchingtheory}}).
}
\details{
When the score matching discrepancy function is of quadratic form, then the gradient of the score matching discrepancy is zero at \eqn{H^{-1}b}{solve(H) \%*\% b},
where \eqn{H} is the average of the Hessian of the score matching discrepancy function evaluated at each measurement and
\eqn{b} is the average of the gradient offset (see \code{\link[=quadratictape_parts]{quadratictape_parts()}}) evaluated at each measurement.
Both the Hessian and the gradient offset are constant with respect to the model parameters for quadratic-form score matching discrepancy functions.

Standard errors are estimated using the Godambe information matrix (aka sandwich method) and are only computed when the weights are constant.
The estimate of the negative of the sensitivity matrix \eqn{-G} is
the average of the Hessian of \code{smdtape} evaluated at each observation in \code{Y}.
The estimate of the variability matrix \eqn{J} is
the sample covariance (denominator of \eqn{n-1}) of the gradient of \code{smdtape} evaluated at each of the observations in \code{Y} for the estimated \eqn{\theta}.
The estimated variance of the estimator is then as
\eqn{G^{-1}JG^{-1}/n,}
where \code{n} is the number of observations.

Taylor approximation is available because boundary weight functions and transformations of the measure in Hyvärinen divergence can remove singularities in the model log-likelihood, however evaluation at these singularities may still involve computing intermediate values that are unbounded.
If the singularity is ultimately removed, then Taylor approximation from a nearby location will give a very accurate evaluation at the removed singularity.
}
\examples{
smdtape <- tape_smd("sim", "sqrt", "sph", "ppi",
              ytape = rep(1/3, 3),
              usertheta = ppi_paramvec(p = 3),
              bdryw = "minsq", acut = 0.01,
              verbose = FALSE
              )$smdtape
Y <- rppi_egmodel(100)
cppad_closed(smdtape, Y$sample)
}
\seealso{
Other generic score matching tools: 
\code{\link{Windham}()},
\code{\link{cppad_search}()},
\code{\link{tape_smd}()}
}
\concept{generic score matching tools}
