% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-export-ac.R, R/autocorr.R
\name{print.sc_ac}
\alias{print.sc_ac}
\alias{export.sc_ac}
\alias{autocorr}
\title{Autocorrelation for single-case data}
\usage{
\method{print}{sc_ac}(x, digits = "auto", ...)

\method{export}{sc_ac}(object, caption = NA, footnote = NA, filename = NA, round = 3, ...)

autocorr(data, dvar, pvar, mvar, lag_max = 3, lag.max, ...)
}
\arguments{
\item{x}{An object returned by \code{\link[=autocorr]{autocorr()}}}

\item{digits}{The minimum number of significant digits to be use.
If set to "auto" (default), values are predefined.}

\item{...}{Further arguments passed to the \code{\link[=acf]{acf()}} function}

\item{object}{An scdf or an object exported from a scan function.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{round}{Integer passed to the digits argument used to round values.}

\item{data}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{lag_max, lag.max}{The lag up to which autocorrelations will be computed.}
}
\value{
A data frame containing separate autocorrelations for each phase and
for all phases (for each single-case). If \code{lag_max} exceeds the length
of a phase minus one, NA is returned for this cell.
}
\description{
The autocorr function calculates autocorrelations within each phase and
across all phases.
}
\section{Functions}{
\itemize{
\item \code{print(sc_ac)}: Print method

\item \code{export(sc_ac)}: Export results to html

}}
\examples{
## Compute autocorrelations for a list of four single-cases up to lag 2.
autocorr(Huber2014, lag_max = 2)
}
\seealso{
\code{\link[=acf]{acf()}}

Other regression functions: 
\code{\link{bplm}()},
\code{\link{hplm}()},
\code{\link{mplm}()},
\code{\link{plm}()},
\code{\link{print.sc_bctau}()},
\code{\link{trend}()}
}
\author{
Juergen Wilbert
}
\concept{Autocorrelation}
\concept{Serial correlation}
\concept{regression functions}
\keyword{regression}
