% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Generics.R, R/Object_Conversion.R
\name{as.LIGER}
\alias{as.LIGER}
\alias{as.LIGER.Seurat}
\alias{as.LIGER.list}
\title{Convert objects to LIGER objects}
\usage{
as.LIGER(x, ...)

\method{as.LIGER}{Seurat}(
  x,
  group.by = "orig.ident",
  layers_name = NULL,
  assay = "RNA",
  remove_missing = FALSE,
  renormalize = TRUE,
  use_seurat_var_genes = FALSE,
  use_seurat_dimreduc = FALSE,
  reduction = NULL,
  keep_meta = TRUE,
  verbose = TRUE,
  ...
)

\method{as.LIGER}{list}(
  x,
  group.by = "orig.ident",
  dataset_names = NULL,
  assay = "RNA",
  remove_missing = FALSE,
  renormalize = TRUE,
  use_seurat_var_genes = FALSE,
  var_genes_method = "intersect",
  keep_meta = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object to convert to class \code{liger}}

\item{...}{Arguments passed to other methods}

\item{group.by}{Variable in meta data which contains variable to split data by, (default is "orig.ident").}

\item{layers_name}{name of meta.data column used to split layers if setting \code{group.by = "layers"}.}

\item{assay}{Assay containing raw data to use, (default is "RNA").}

\item{remove_missing}{logical, whether to remove missing genes with no counts when converting to
LIGER object (default is FALSE).}

\item{renormalize}{logical, whether to perform normalization after LIGER object creation (default is TRUE).}

\item{use_seurat_var_genes}{logical, whether to transfer variable features from Seurat object to
new LIGER object (default is FALSE).}

\item{use_seurat_dimreduc}{logical, whether to transfer dimensionality reduction coordinates from
Seurat to new LIGER object (default is FALSE).}

\item{reduction}{Name of Seurat reduction to transfer if \code{use_seurat_dimreduc = TRUE}.}

\item{keep_meta}{logical, whether to transfer columns in Seurat meta.data slot to LIGER cell.data
slot (default is TRUE).}

\item{verbose}{logical, whether to print status messages during object conversion (default is TRUE).}

\item{dataset_names}{optional, vector of names to use for naming datasets.}

\item{var_genes_method}{how variable genes should be selected from Seurat objects if \code{use_seurat_var_genes = TRUE}.  Can be either "intersect" or "union", (default is "intersect").}
}
\value{
a liger object generated from \code{x}
}
\description{
Convert objects (Seurat & lists of Seurat Objects) to anndata objects
}
\examples{
\dontrun{
liger_object <- as.LIGER(x = seurat_object)
}

\dontrun{
liger_object <- as.LIGER(x = seurat_object_list)
}

}
\references{
modified and enhanced version of \code{rliger::seuratToLiger}.
}
\concept{object_conversion}
