% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities_Objects.R
\name{Store_Palette_Seurat}
\alias{Store_Palette_Seurat}
\title{Store color palette in Seurat object}
\usage{
Store_Palette_Seurat(
  seurat_object,
  palette,
  palette_name,
  list_as_list = FALSE,
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{seurat_object}{object name.}

\item{palette}{vector or list of vectors containing color palettes to store.  If list of palettes
see \code{list_as_list} parameter for control over data storage.}

\item{palette_name}{name to give the palette(s) in \verb{@misc} slot.  Must be of equal length to the number
of data items being stored.}

\item{list_as_list}{logical.  If \code{data_to_store} is a list, this dictates whether to store in \verb{@misc} slot
as list (TRUE) or whether to store each entry in the list separately (FALSE).  Default is FALSE.}

\item{overwrite}{Logical.  Whether to overwrite existing items with the same name.  Default is FALSE, meaning
that function will abort if item with \code{data_name} is present in misc slot.}

\item{verbose}{logical, whether to print messages when running function, default is TRUE.}
}
\value{
Seurat Object with new entries in the \verb{@misc} slot.
}
\description{
Wrapper function around \code{Store_Misc_Info_Seurat} to store color palettes.
}
\examples{
library(Seurat)
clu_pal <- c("red", "green", "blue")

pbmc_small <- Store_Misc_Info_Seurat(seurat_object = pbmc_small, data_to_store = clu_pal,
data_name = "rd1_colors")

}
\concept{get_set_util}
