% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_QC_Seurat.R
\name{QC_Plots_Complexity}
\alias{QC_Plots_Complexity}
\title{QC Plots Cell "Complexity"}
\usage{
QC_Plots_Complexity(
  seurat_object,
  feature = "log10GenesPerUMI",
  group.by = NULL,
  x_axis_label = NULL,
  y_axis_label = "log10(Genes) / log10(UMIs)",
  plot_title = "Cell Complexity",
  low_cutoff = NULL,
  high_cutoff = NULL,
  cutoff_line_width = NULL,
  pt.size = NULL,
  plot_median = FALSE,
  plot_boxplot = FALSE,
  median_size = 15,
  colors_use = NULL,
  x_lab_rotate = TRUE,
  y_axis_log = FALSE,
  raster = NULL,
  ggplot_default_colors = FALSE,
  color_seed = 123,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{feature}{Feature from Meta Data to plot.}

\item{group.by}{Name of one or more metadata columns to group (color) cells by (for example, orig.ident);
default is the current active.ident of the object.}

\item{x_axis_label}{Label for x axis.}

\item{y_axis_label}{Label for y axis.}

\item{plot_title}{Plot Title.}

\item{low_cutoff}{Plot line a potential low threshold for filtering.}

\item{high_cutoff}{Plot line a potential high threshold for filtering.}

\item{cutoff_line_width}{numerical value for thickness of cutoff lines, default is NULL.}

\item{pt.size}{Point size for plotting}

\item{plot_median}{logical, whether to plot median for each ident on the plot (Default is FALSE).}

\item{plot_boxplot}{logical, whether to plot boxplot inside of violin (Default is FALSE).}

\item{median_size}{Shape size for the median is plotted.}

\item{colors_use}{vector of colors to use for plot.}

\item{x_lab_rotate}{Rotate x-axis labels 45 degrees (Default is TRUE).}

\item{y_axis_log}{logical. Whether to change y axis to log10 scale (Default is FALSE).}

\item{raster}{Convert points to raster format.  Default is NULL which will rasterize by default if
greater than 100,000 total points plotted (# Cells x # of features).}

\item{ggplot_default_colors}{logical.  If \code{colors_use = NULL}, Whether or not to return plot using
default ggplot2 "hue" palette instead of default "polychrome" or "varibow" palettes.}

\item{color_seed}{random seed for the "varibow" palette shuffle if \code{colors_use = NULL} and number of
groups plotted is greater than 36.  Default = 123.}

\item{...}{Extra parameters passed to \code{\link[Seurat]{VlnPlot}}.}
}
\value{
A ggplot object
}
\description{
Custom VlnPlot for initial QC checks including lines for thresholding
}
\examples{
library(Seurat)
pbmc_small <- Add_Cell_Complexity(pbmc_small)

QC_Plots_Complexity(seurat_object = pbmc_small)

}
\concept{object_qc_plotting}
