% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIGER_Utilities.R
\name{Idents.liger}
\alias{Idents.liger}
\alias{Idents<-.liger}
\title{Extract or set default identities from object}
\usage{
\method{Idents}{liger}(object, ...)

\method{Idents}{liger}(object, ...) <- value
}
\arguments{
\item{object}{LIGER object name.}

\item{...}{Arguments passed to other methods}

\item{value}{name of column in cellMeta slot to set as new default cluster/ident}
}
\value{
factor

object
}
\description{
Extract default identities from object in factor form.
}
\note{
Use of Idents<- is only for setting new default ident/cluster from column already present in cellMeta.
To add new column with new cluster values to cellMeta and set as default see \code{\link{Rename_Clusters}}.
}
\examples{
\dontrun{
# Extract idents
object_idents <- Idents(object = liger_object)
}

\dontrun{
# Set idents
Idents(object = liger_object) <- "new_annotation"
}

}
\concept{liger_object_util}
