% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draws.R
\name{draws_fun}
\alias{draws_fun}
\alias{draws_fun.rvec}
\title{Apply Summary Function Across Random Draws}
\usage{
draws_fun(x, fun, ...)

\method{draws_fun}{rvec}(x, fun, ...)
}
\arguments{
\item{x}{An object of class \link[=rvec]{rvec}.}

\item{fun}{A function.}

\item{...}{Additional arguments passed to \code{fun}.}
}
\value{
The results from calls to \code{fun},
combined using \code{\link[vctrs:vec_c]{vctrs::vec_c()}}.
}
\description{
Summarise the distribution of random draws
in an rvec, using a function.
}
\examples{
set.seed(0)
m <- rbind(a = rnorm(100, mean = 5, sd = 2),
           b = rnorm(100, mean = -3, sd = 3),
           c = rnorm(100, mean = 0, sd = 20))
x <- rvec(m)
x
draws_fun(x, fun = mad)
draws_fun(x, fun = range)
draws_fun(x, weighted.mean, wt = runif(100))
draws_fun(x, function(x) sd(x) / mean(x))
}
\seealso{
Apply pre-specified functions across draws:
\itemize{
\item \code{\link[=draws_all]{draws_all()}}
\item \code{\link[=draws_any]{draws_any()}}
\item \code{\link[=draws_min]{draws_min()}}
\item \code{\link[=draws_max]{draws_max()}}
\item \code{\link[=draws_median]{draws_median()}}
\item \code{\link[=draws_mean]{draws_mean()}}
\item \code{\link[=draws_mode]{draws_mode()}}
\item \code{\link[=draws_sd]{draws_sd()}}
\item \code{\link[=draws_var]{draws_var()}}
\item \code{\link[=draws_cv]{draws_cv()}}
\item \code{\link[=draws_ci]{draws_ci()}}
\item \code{\link[=draws_quantile]{draws_quantile()}}
}
}
